IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='PG_CRED_ORDEM_PGTO_STONE_STATUS') 
BEGIN
	CREATE TABLE [PG_CRED_ORDEM_PGTO_STONE_STATUS]
	(
		[CD_STATUS]			INT				NOT NULL,
		[NM_STATUS]			VARCHAR(250)	NOT NULL,

		CONSTRAINT [PK_PG_CRED_ORDEM_PGTO_STONE_STATUS] PRIMARY KEY ([CD_STATUS])
	)
END
GO

IF EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='PG_CRED_ORDEM_PGTO_STONE_STATUS') 
BEGIN
	IF NOT EXISTS (SELECT TOP 1 CD_STATUS FROM PG_CRED_ORDEM_PGTO_STONE_STATUS)
	BEGIN
		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (0, 'NO CRIADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (1, 'CRIADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (2, 'APROVADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (3, 'REJEITADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (4, 'EXPIRADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (5, 'AGENDADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (6, 'FALHA')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (7, 'CANCELADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (8, 'FINALIZADO')

		INSERT PG_CRED_ORDEM_PGTO_STONE_STATUS (CD_STATUS, NM_STATUS)
		VALUES (9, 'DEVOLVIDO')
	END
END
GO

IF NOT EXISTS(SELECT 1 FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME='PG_CRED_ORDEM_PGTO_STONE') 
BEGIN
	CREATE TABLE [PG_CRED_ORDEM_PGTO_STONE]
	(
		[CD_EMP]			INT				NOT NULL,
		[CD_FILIAL]			INT				NOT NULL,
		[CD_PG_CRED]		INT				NOT NULL,
		[CD_PG_CRED_ORDEM]	INT				NOT NULL,
		[SITUACAO]			BIT				NOT NULL,
		[ACCOUNT_ID]		VARCHAR(40)		NOT NULL,
		[ID_ORDEM_STONE]	VARCHAR(50)			NULL,
		[CD_STATUS]			INT				NOT NULL,
		[MOTIVO]			VARCHAR(140)		NULL,
		[VLR_AMOUNT]		MONEY				NULL,
		[DT_PGTO]			DATETIME			NULL,
		[CD_USU]			INT				NOT NULL,
		[DT_CAD]			DATETIME		NOT NULL,
		[DT_ULT_ALT]		DATETIME		NOT NULL CONSTRAINT DF_PG_CRED_ORDEM_PGTO_STONE_DT_ULT_ALT DEFAULT (GETDATE())

		CONSTRAINT [PK_PG_CRED_ORDEM_PGTO_STONE] PRIMARY KEY ([CD_EMP], [CD_FILIAL], [CD_PG_CRED], [CD_PG_CRED_ORDEM]),
		CONSTRAINT [FK_PG_CRED_ORDEM_PGTO_STONE_PG_CRED_ORDEM_PGTO_STONE_STATUS] FOREIGN KEY ([CD_STATUS]) REFERENCES PG_CRED_ORDEM_PGTO_STONE_STATUS ([CD_STATUS])
	)
END
GO